@extends('karyawan.layout.master')

@section('title', 'Slip Gaji')

@section('content')
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', sans-serif;
    }

    body {
        margin: 0;
        padding: 0;
        background: #ffffff;
        overflow: hidden;
    }

    .fullscreen-wrapper {
        margin-top: 70px;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        display: flex;
        flex-direction: column;
        background: #ffffff;
    }

    /* Header Bar */
    .header-bar {
        margin-top: 70px;
        background: #2d2d2e;
        color: white;
        padding: 18px 20px;
        display: flex;
        align-items: center;
        gap: 16px;
        flex-shrink: 0;
    }

    .header-title {
        font-size: 18px;
        font-weight: 500;
    }

    /* Filter Section */
    .filter-section {
        background: #f8f9fa;
        padding: 14px 20px;
        border-bottom: 1px solid #e9ecef;
        flex-shrink: 0;
    }

    .filter-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 10px;
    }

    .filter-item {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 10px 14px;
        background: white;
        border: 1px solid #dee2e6;
        border-radius: 8px;
        cursor: pointer;
    }

    .filter-item i {
        color: #6c757d;
        font-size: 14px;
    }

    .filter-text {
        flex: 1;
        font-size: 13px;
        color: #495057;
        font-weight: 500;
    }

    .filter-input {
        display: none;
    }

    /* Gaji List */
    .gaji-list {
        margin-bottom: 70px;
        flex: 1;
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
        background: #ffffff;
    }

    /* List Item */
    .list-item {
        padding: 16px 20px;
        border-bottom: 1px solid #f0f0f0;
        background: white;
        transition: background 0.2s;
    }

    .list-item:active {
        background: #fafafa;
    }

    .item-header {
        display: flex;
        align-items: center;
        gap: 12px;
        margin-bottom: 12px;
    }

    .month-box {
        width: 48px;
        height: 48px;
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        color: white;
        border-radius: 8px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    .month-short {
        font-size: 12px;
        font-weight: 700;
        text-transform: uppercase;
        line-height: 1;
    }

    .year-num {
        font-size: 11px;
        font-weight: 600;
        opacity: 0.9;
        margin-top: 2px;
    }

    .item-title {
        flex: 1;
    }

    .period-name {
        font-size: 15px;
        font-weight: 600;
        color: #212529;
        margin-bottom: 2px;
    }

    .period-subtitle {
        font-size: 12px;
        color: #6c757d;
    }

    .amount-box {
        text-align: right;
    }

    .amount-label {
        font-size: 10px;
        color: #6c757d;
        margin-bottom: 2px;
        text-transform: uppercase;
        font-weight: 600;
    }

    .amount-value {
        font-size: 16px;
        font-weight: 700;
        color: #28a745;
    }

    /* Item Details */
    .item-details {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 12px;
        padding-top: 12px;
        border-top: 1px solid #f0f0f0;
    }

    .detail-item {
        text-align: center;
    }

    .detail-label {
        font-size: 10px;
        color: #6c757d;
        margin-bottom: 4px;
        text-transform: uppercase;
        font-weight: 600;
    }

    .detail-value {
        font-size: 14px;
        font-weight: 600;
        color: #212529;
    }

    /* Action Buttons */
    .action-buttons {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 8px;
        margin-top: 12px;
    }

    .btn-action {
        padding: 8px 16px;
        border: none;
        border-radius: 6px;
        font-size: 13px;
        font-weight: 600;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        text-decoration: none;
        transition: all 0.2s;
    }

    .btn-detail {
        background: #e7f3ff;
        color: #0066cc;
    }

    .btn-detail:hover {
        background: #cce5ff;
        color: #0052a3;
    }

    .btn-download {
        background: #d4edda;
        color: #155724;
    }

    .btn-download:hover {
        background: #c3e6cb;
        color: #0b2e13;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 80px 20px;
    }

    .empty-icon {
        width: 64px;
        height: 64px;
        margin: 0 auto 16px;
        background: #f8f9fa;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #adb5bd;
        font-size: 28px;
    }

    .empty-state h3 {
        font-size: 16px;
        color: #495057;
        margin-bottom: 6px;
        font-weight: 600;
    }

    .empty-state p {
        font-size: 13px;
        color: #adb5bd;
    }

    /* Summary Card */
    .summary-card {
        margin: 16px 20px;
        padding: 16px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 12px;
        color: white;
    }

    .summary-title {
        font-size: 12px;
        opacity: 0.9;
        margin-bottom: 8px;
        text-transform: uppercase;
        font-weight: 600;
    }

    .summary-amount {
        font-size: 24px;
        font-weight: 700;
        margin-bottom: 4px;
    }

    .summary-subtitle {
        font-size: 11px;
        opacity: 0.8;
    }
</style>

<div class="fullscreen-wrapper">
    <!-- Filter -->
    <div class="filter-section">
        <form method="GET" id="filterForm">
            <div class="filter-grid">
                <label for="tahun" class="filter-item">
                    <i class="far fa-calendar"></i>
                    <span class="filter-text" id="tahunText">
                        {{ $tahun ?? date('Y') }}
                    </span>
                    <i class="fas fa-chevron-down" style="font-size: 10px;"></i>
                </label>

                <label for="bulan" class="filter-item">
                    <i class="far fa-calendar-alt"></i>
                    <span class="filter-text" id="bulanText">
                        @if($bulan)
                            {{ \Carbon\Carbon::create()->month($bulan)->locale('id')->monthName }}
                        @else
                            Semua Bulan
                        @endif
                    </span>
                    <i class="fas fa-chevron-down" style="font-size: 10px;"></i>
                </label>
            </div>

            <select name="tahun" id="tahun" class="filter-input" onchange="this.form.submit()">
                <option value="">Semua Tahun</option>
                @for($y = date('Y'); $y >= date('Y') - 5; $y--)
                    <option value="{{ $y }}" {{ ($tahun ?? '') == $y ? 'selected' : '' }}>
                        {{ $y }}
                    </option>
                @endfor
            </select>

            <select name="bulan" id="bulan" class="filter-input" onchange="this.form.submit()">
                <option value="">Semua Bulan</option>
                @for($m = 1; $m <= 12; $m++)
                    <option value="{{ $m }}" {{ ($bulan ?? '') == $m ? 'selected' : '' }}>
                        {{ \Carbon\Carbon::create()->month($m)->locale('id')->monthName }}
                    </option>
                @endfor
            </select>
        </form>
    </div>

    <!-- Summary (optional - jika ada data) -->
    @if($gaji->count() > 0 && $bulan)
        @php
            $totalGaji = $gaji->sum('total_gaji');
            $totalHadir = $gaji->sum('total_hadir');
        @endphp
        <div class="summary-card">
            <div class="summary-title">Total Gaji Bulan Ini</div>
            <div class="summary-amount">Rp {{ number_format($totalGaji, 0, ',', '.') }}</div>
            <div class="summary-subtitle">{{ $totalHadir }} hari hadir</div>
        </div>
    @endif

    <!-- List -->
    <div class="gaji-list">
        @forelse($gaji as $g)
            @php
                $bulanNama = \Carbon\Carbon::create()->month($g->bulan)->locale('id')->monthName;
                $bulanShort = strtoupper(substr($bulanNama, 0, 3));
            @endphp

            <div class="list-item">
                <div class="item-header">
                    <div class="month-box">
                        <div class="month-short">{{ $bulanShort }}</div>
                        <div class="year-num">{{ $g->tahun }}</div>
                    </div>

                    <div class="item-title">
                        <div class="period-name">{{ $bulanNama }} {{ $g->tahun }}</div>
                        <div class="period-subtitle">Periode Gaji</div>
                    </div>

                    <div class="amount-box">
                        <div class="amount-label">Total</div>
                        <div class="amount-value">
                            {{ number_format($g->total_gaji / 1000, 0) }}K
                        </div>
                    </div>
                </div>

                <div class="item-details">
                    <div class="detail-item">
                        <div class="detail-label">Hadir</div>
                        <div class="detail-value">{{ $g->total_hadir }} hari</div>
                    </div>

                    <div class="detail-item">
                        <div class="detail-label">Gaji Pokok</div>
                        <div class="detail-value">{{ number_format($g->gaji_pokok / 1000, 0) }}K</div>
                    </div>

                    <div class="detail-item">
                        <div class="detail-label">Tunjangan</div>
                        <div class="detail-value">{{ number_format($g->total_tunjangan / 1000, 0) }}K</div>
                    </div>
                </div>

                <div class="action-buttons">
                    <a href="{{ route('karyawan.gaji.slip', $g->id) }}" class="btn-action btn-detail">
                        <i class="fas fa-file-alt"></i> Detail
                    </a>
                    <a href="{{ route('karyawan.gaji.download', $g->id) }}" class="btn-action btn-download">
                        <i class="fas fa-download"></i> PDF
                    </a>
                </div>
            </div>
        @empty
            <div class="empty-state">
                <div class="empty-icon">
                    <i class="fas fa-wallet"></i>
                </div>
                <h3>Tidak ada data</h3>
                <p>Belum ada slip gaji untuk filter yang dipilih</p>
            </div>
        @endforelse
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tahun picker
    document.querySelector('label[for="tahun"]').addEventListener('click', function() {
        document.getElementById('tahun').click();
    });

    // Bulan picker
    document.querySelector('label[for="bulan"]').addEventListener('click', function() {
        document.getElementById('bulan').click();
    });

    // Touch feedback
    const items = document.querySelectorAll('.list-item');
    items.forEach(item => {
        item.addEventListener('touchstart', () => {
            item.style.transform = 'scale(0.98)';
        });
        item.addEventListener('touchend', () => {
            item.style.transform = 'scale(1)';
        });
    });

    // Update filter text when changed
    document.getElementById('tahun').addEventListener('change', function() {
        const text = this.options[this.selectedIndex].text;
        document.getElementById('tahunText').textContent = text;
    });

    document.getElementById('bulan').addEventListener('change', function() {
        const text = this.options[this.selectedIndex].text;
        document.getElementById('bulanText').textContent = text;
    });
});
</script>
@endsection
